/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.mc6809;

import frc.emul.api.IInstruction;
import frc.emul.mc6809.Mode;
import frc.emul.mc6809.Operand;
import java.lang.reflect.Method;

public class Instruction
implements IInstruction {
    private final Operand op;
    private final String name;
    private final Mode mode;
    private final int opcode;
    private final int baseCycles;
    private final boolean documented;
    private final boolean targetIsReg8;
    public final Method execMethod;

    Instruction(int n, String string, Mode mode, Operand operand, int n2, boolean bl, Method method) {
        this.op = operand;
        this.name = string;
        this.mode = mode;
        this.opcode = n;
        this.baseCycles = n2;
        this.documented = bl;
        this.execMethod = method;
        this.targetIsReg8 = operand.isRegister() && operand.isReg8();
    }

    public final Method getSimulatorMethod() {
        return this.execMethod;
    }

    public Operand getOp() {
        return this.op;
    }

    public Mode getMode() {
        return this.mode;
    }

    public String getName() {
        return this.name;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public int getOpcodeLen() {
        return this.opcode < 256 ? 1 : 2;
    }

    public int getBaseCycles() {
        return this.baseCycles;
    }

    public boolean isDocumented() {
        return this.documented;
    }

    public boolean isTargetReg8() {
        return this.targetIsReg8;
    }

    public boolean isPage0() {
        return this.opcode < 256;
    }

    public boolean isPage1() {
        return 4096 == (0xFF00 & this.opcode);
    }

    public boolean isPage2() {
        return 4352 == (0xFF00 & this.opcode);
    }
}

